<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * SiteController
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */
 
class SiteController extends Controller
{
	 
		
	public function init(){
	 
        // register class paths for extension captcha extended
        Yii::$classMap = array_merge( Yii::$classMap, array(
            'CaptchaExtendedAction' => Yii::getPathOfAlias('root.apps.extensions.captchaExtended').DIRECTORY_SEPARATOR.'CaptchaExtendedAction.php',
            'CaptchaExtendedValidator' => Yii::getPathOfAlias('root.apps.extensions.captchaExtended').DIRECTORY_SEPARATOR.'CaptchaExtendedValidator.php'
        ));
    }
	
	  public function actions(){
        return array(
  
            'captcha'=>array(
                'class'=>'CaptchaExtendedAction',
                // if needed, modify settings
                'mode'=>CaptchaExtendedAction::MODE_WORDS,
            ),
            'page'=>array(
				'class'=>'CViewAction',
			),
        );
    } 
 
    public function actionLogins()
	{
		$this->render("logins");
	}
	public function actionHoauth()
	{
		$this->render("hoauth");
	}
	public function actionProfile()
	{ 
		$this->render("profile");
	}
	  
    public function actionIndex()
    {
		 
	 
		
	 $this->layout =   Yii::app()->LayoutClass->layoutpath("main"); 
	 $model = Section::model()->listData();
	 $section  = Section::model()->auto_prioritySection(Yii::app()->params['auto']);
	 //$realEstate  = Section::model()->auto_prioritySection(Yii::app()->params['realEstate']);
	 $travel  = Section::model()->auto_prioritySection(Yii::app()->params['travel']);
	 $deals  = Section::model()->auto_prioritySection(Yii::app()->params['deals']);
	 $dirctory  = Section::model()->auto_prioritySection(Yii::app()->params['dirctory']);
	 
	 $classifieds = Category::model()->getCatgeory(Yii::app()->params['classifieds']);
	 $for_rent = Section::model()->findByPk(Yii::app()->params['for_rent']);
	 $for_sale = Section::model()->findByPk(Yii::app()->params['for_sale']);
	 $matrimonial = Category::model()->getCatgeory(Yii::app()->params['matrimonial']);
 
	 $jobs = Category::model()->getCatgeory(Yii::app()->params['jobs']);
	 
	 $this->setData(array(
                    'pageMetaTitle'         => Yii::t('app', '{name} :: home', array('{name}' => Yii::app()->name )), 
                    'pageMetaDescription'   => Yii::app()->params['description'],
                ));
                
	 $this->render( Yii::app()->LayoutClass->viewpath("index"),compact("model","realEstate","section","dirctory","deals","travel","classifieds","for_rent","for_sale","matrimonial","jobs"));
    }
    
    public function actionOffline()
    {
        if (Yii::app()->options->get('system.common.site_status') !== 'offline') {
            $this->redirect(array('site/index'));
        }
        
        throw new CHttpException(503, Yii::app()->options->get('system.common.site_offline_message'));
    }
    
    public function actionError()
    {
		$this->layout =   Yii::app()->LayoutClass->layoutpath("fullwidth"); 
        if ($error = Yii::app()->errorHandler->error) {
            if (Yii::app()->request->isAjaxRequest) {
                echo CHtml::encode($error['message']);
            } else {
                $this->setData(array(
                    'pageMetaTitle'         => Yii::t('app', 'Error {code}!', array('{code}' => $error['code'])), 
                    'pageMetaDescription'   => $error['message'],
                ));
                $this->render( Yii::app()->LayoutClass->viewpath("error"), $error) ;
            }    
        }
    }
    public function actionSocial()
    {
		$this->render("social");
	}
 

}
